<?php
/**
 * Plugin Name: JMT Browser
 * Plugin Slug: jmtbrowser
 * Description: Productbrowser voor JMT producten – caching en offertemodule.
 * Version: 2.2.8
 * License: GPL
 * Author: Dirk Zaal, Digizaal
 * Copyright: JMT international 2025
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'JMTB_VERSION', '2.2.8' );
define( 'JMTB_DIR', plugin_dir_path( __FILE__ ) );
define( 'JMTB_URL', plugin_dir_url( __FILE__ ) );

// Autoloader
spl_autoload_register( function( $class ) {
    if ( strpos( $class, 'JMT_' ) === 0 ) {
        $file = JMTB_DIR . 'includes/class-' . strtolower( str_replace( '_', '-', $class ) ) . '.php';
        if ( file_exists( $file ) ) {
            require_once $file;
        }
    }
} );

// Activation hook
register_activation_hook( __FILE__, function() {
    JMT_Fetcher::instance()->maybe_install_table();
    JMT_Requests::instance()->maybe_install_table();
} );

// Boot plugin
add_action( 'plugins_loaded', function() {
    JMT_Settings::instance();
    JMT_Fetcher::instance();
    JMT_Frontend::instance();
    JMT_Admin::init();
} );
