<?php
if ( class_exists( 'JMT_Requests' ) ) return;

class JMT_Requests {

    private static $instance;

    public static function instance() {
        return self::$instance ?: self::$instance = new self();
    }

    private function __construct() {}

    // ── Table ─────────────────────────────────────────────────────────────────

    public function maybe_install_table() {
        if ( get_option( 'jmt_requests_db_version' ) !== '1.1' ) {
            $this->create_table();
            update_option( 'jmt_requests_db_version', '1.1' );
        }
    }

    private function create_table() {
        global $wpdb;
        $table   = $wpdb->prefix . 'jmt_requests';
        $charset = $wpdb->get_charset_collate();
        $sql     = "CREATE TABLE {$table} (
            id         BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            created    DATETIME        NOT NULL DEFAULT CURRENT_TIMESTAMP,
            name       VARCHAR(100)    NOT NULL,
            email      VARCHAR(100)    NOT NULL,
            company    VARCHAR(150)        NULL,
            event_name VARCHAR(150)        NULL,
            event_date DATE                NULL,
            cart       LONGTEXT        NOT NULL,
            PRIMARY KEY (id)
        ) {$charset};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );
    }

    // ── CRUD ──────────────────────────────────────────────────────────────────

    public function insert_request( array $data ) {
        global $wpdb;
        $table = $wpdb->prefix . 'jmt_requests';

        $result = $wpdb->insert( $table, [
            'name'       => sanitize_text_field( $data['name'] ),
            'email'      => sanitize_email( $data['email'] ),
            'company'    => sanitize_text_field( $data['company']    ?? '' ),
            'event_name' => sanitize_text_field( $data['event_name'] ?? '' ),
            'event_date' => sanitize_text_field( $data['event_date'] ?? '' ) ?: null,
            'cart'       => wp_json_encode( $data['cart'] ),
        ] );

        return $result ? (int) $wpdb->insert_id : 0;
    }

    public function get_all( $page = 1, $per_page = 50 ) {
        global $wpdb;
        $table  = $wpdb->prefix . 'jmt_requests';
        $offset = ( $page - 1 ) * $per_page;

        $rows = $wpdb->get_results( $wpdb->prepare(
            "SELECT * FROM {$table} ORDER BY created DESC LIMIT %d OFFSET %d",
            $per_page, $offset
        ), ARRAY_A );

        foreach ( $rows as &$row ) {
            $cart = json_decode( $row['cart'], true );
            $row['cart'] = is_array( $cart ) ? $cart : [];
        }

        return $rows ?: [];
    }

    public function count_all() {
        global $wpdb;
        return (int) $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}jmt_requests" );
    }
}
