<?php
if ( class_exists( 'JMT_Admin' ) ) return;

class JMT_Admin {

    private static function is_nl_admin() {
        $loc = function_exists( 'get_user_locale' ) ? get_user_locale() : ( function_exists( 'determine_locale' ) ? determine_locale() : get_locale() );
        $loc = strtolower( (string) $loc );
        return substr( $loc, 0, 2 ) === 'nl';
    }

    private static function t( $nl, $en ) {
        return self::is_nl_admin() ? $nl : $en;
    }

    public static function init() {
        add_action( 'admin_menu', [ self::class, 'register_menus' ] );
        add_action( 'admin_enqueue_scripts', [ self::class, 'enqueue_assets' ] );
    }

    public static function enqueue_assets( $hook ) {
        if ( strpos( $hook, 'jmt' ) === false ) return;
        wp_enqueue_style( 'jmt-admin-style', JMTB_URL . 'assets/css/admin.css', [], JMTB_VERSION );
    }

    public static function register_menus() {
        add_menu_page(
            'JMT Browser',
            'JMT Browser',
            'manage_options',
            'jmt-browser',
            [ self::class, 'page_info' ],
            'dashicons-cart',
            58
        );
        add_submenu_page( 'jmt-browser', self::t( 'Aanvragen', 'Requests' ),    self::t( 'Aanvragen', 'Requests' ),    'manage_options', 'jmt-requests',  [ self::class, 'page_requests' ] );
        add_submenu_page( 'jmt-browser', self::t( 'Instellingen', 'Settings' ), self::t( 'Instellingen', 'Settings' ), 'manage_options', 'jmt-settings',  [ self::class, 'page_settings' ] );
    }

    // ── Info page ─────────────────────────────────────────────────────────────

    public static function page_info() {
        $logo = JMTB_URL . 'assets/images/jmt-logo.png';
        echo '<div class="wrap">';
        echo '<img src="' . esc_url( $logo ) . '" alt="JMT Logo" style="max-width:200px;margin:1em 0 0.5em;">';
        echo '<h1>JMT Browser <span style="font-size:0.6em;color:#888">v' . esc_html( JMTB_VERSION ) . '</span></h1>';
        echo '<p>' . esc_html( self::t(
            'Productbrowser voor JMT verhuurmeubilair met offerte-module.',
            'Product browser for JMT rental furniture with quotation module.'
        ) ) . '</p>';
        echo '<hr>';
        echo '<h2>' . esc_html( self::t( 'Gebruik', 'Usage' ) ) . '</h2>';
        echo '<p>' . wp_kses_post( self::t(
            'Voeg de shortcode <code>[jmt_product_browser]</code> toe aan een pagina om de productbrowser te tonen.',
            'Add the shortcode <code>[jmt_product_browser]</code> to a page to display the product browser.'
        ) ) . '</p>';
        echo '<h2>' . esc_html( self::t( 'Werking', 'How it works' ) ) . '</h2>';
        echo '<ul>';
        echo '<li>' . esc_html( self::t(
            'Producten worden opgehaald van de JMT datafeed en gecached in de database.',
            'Products are fetched from the JMT data feed and cached in the database.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Bezoekers kunnen producten bekijken, filteren op categorie en toevoegen aan de offerte-aanvraag.',
            'Visitors can browse products, filter by category and add items to a quotation request.'
        ) ) . '</li>';
        echo '<li>' . wp_kses_post( self::t(
            'Aanvragen zijn terug te vinden onder <strong>Aanvragen</strong>.',
            'Requests can be found under <strong>Requests</strong>.'
        ) ) . '</li>';
        echo '<li>' . wp_kses_post( self::t(
            'Pas het notificatie-e-mailadres en cacheinstellingen aan onder <strong>Instellingen</strong>.',
            'Adjust the notification email address and cache settings under <strong>Settings</strong>.'
        ) ) . '</li>';
        echo '</ul>';

        echo '<hr>';
        echo '<h2>' . esc_html( self::t( 'Wat is er veranderd', "What's changed" ) ) . '</h2>';
        echo '<ul>';
        echo '<li>' . esc_html( self::t(
            'Meertalig: de plugin ondersteunt nu Nederlands én Engels (admin-teksten en datafeedkeuze op basis van bezoekerstaal).',
            'Multi-lingual: the plugin now supports Dutch and English (admin texts and data feed selection based on visitor language).'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Duidelijker cachebeheer: aparte cache per taal, met heldere knoppen om cache te legen en opnieuw op te bouwen.',
            'Clearer caching management: separate cache per language, with clear controls to purge and rebuild.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Kleur-swatches in de frontend: 1em kleurblokjes in de filterlijst en swatch-knoppen in de productpopup.',
            'Color swatches in the front end: 1em swatches in the filter list and swatch buttons in the product modal.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Interface-verbeteringen: compactere zijbalk, accordion-filters en consistentere kleurselectie in de popup.',
            'Interface improvements: more compact sidebar, accordion filters and more consistent color selection in the modal.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Responsive hamburger-menu: op mobiel worden categorieën en kleuren verborgen achter een uitklapknop. Na selectie sluit het menu automatisch.',
            'Responsive hamburger menu: on mobile, categories and colours are hidden behind a toggle button. The menu closes automatically after a selection.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Twee producten per rij op mobiel: het productraster toont altijd twee kolommen op kleine schermen.',
            'Two products per row on mobile: the product grid always shows two columns on small screens.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Paginering scrolt terug naar boven: bij het bladeren naar een volgende of vorige pagina scrollt de pagina automatisch naar het begin van de producten.',
            'Pagination scrolls back to top: when navigating to another page the view automatically scrolls to the top of the product grid.'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Twee-kleurige swatches in de popup: artikelen met een kleurvariant als "WIT / DONKER BLAUW" krijgen een diagonaal gesplitst kleurvlakje (linksboven = eerste kleur, rechtsonder = tweede kleur).',
            'Bi-colour swatches in the modal: items with a colour variant such as "WIT / DONKER BLAUW" display a diagonally split swatch (top-left = first colour, bottom-right = second colour).'
        ) ) . '</li>';
        echo '<li>' . esc_html( self::t(
            'Uitgebreide kleurpalette: "Donker blauw" en "Zand" zijn toegevoegd als herkende kleuren met bijpassende swatch.',
            'Extended colour palette: "Donker blauw" (dark blue) and "Zand" (sand) added as recognised colours with matching swatches.'
        ) ) . '</li>';
        echo '</ul>';

        echo '<p><em>Gemaakt door <a href="https://digizaal.nl" target="_blank">Dirk Zaal, Digizaal</a> voor JMT International.</em></p>';
        echo '</div>';
    }

    // ── Requests page ─────────────────────────────────────────────────────────

    public static function page_requests() {
        $requests = JMT_Requests::instance()->get_all();
        echo '<div class="wrap"><h1>' . esc_html( self::t( 'Offerte-aanvragen', 'Quotation requests' ) ) . '</h1>';

        if ( empty( $requests ) ) {
            echo '<p>' . esc_html( self::t( 'Er zijn nog geen aanvragen.', 'There are no requests yet.' ) ) . '</p></div>';
            return;
        }

        echo '<table class="wp-list-table widefat fixed striped">';
        echo '<thead><tr>
                <th style="width:40px">ID</th>
                <th>' . esc_html( self::t( 'Naam', 'Name' ) ) . '</th>
                <th>' . esc_html( self::t( 'E-mail', 'Email' ) ) . '</th>
                <th>' . esc_html( self::t( 'Bedrijf', 'Company' ) ) . '</th>
                <th>' . esc_html( self::t( 'Event', 'Event' ) ) . '</th>
                <th>' . esc_html( self::t( 'Eventdatum', 'Event date' ) ) . '</th>
                <th>' . esc_html( self::t( 'Aangemaakt', 'Created' ) ) . '</th>
                <th style="width:90px">' . esc_html( self::t( 'Actie', 'Action' ) ) . '</th>
              </tr></thead><tbody>';

        foreach ( $requests as $req ) {
            $json = esc_attr( wp_json_encode( $req ) );
            echo '<tr data-request=\'' . $json . '\'>';
            echo '<td>' . esc_html( $req['id'] ) . '</td>';
            echo '<td>' . esc_html( $req['name'] ) . '</td>';
            echo '<td>' . esc_html( $req['email'] ) . '</td>';
            echo '<td>' . esc_html( $req['company']    ?? '' ) . '</td>';
            echo '<td>' . esc_html( $req['event_name'] ?? '' ) . '</td>';
            echo '<td>' . esc_html( $req['event_date'] ?? '' ) . '</td>';
            echo '<td>' . esc_html( $req['created'] ) . '</td>';
            echo '<td><button class="button jmt-view-req">' . esc_html( self::t( 'Bekijken', 'View' ) ) . '</button></td>';
            echo '</tr>';
        }

        echo '</tbody></table>';

        // Detail modal
        echo '
        <div id="jmt-req-modal" style="display:none;position:fixed;inset:0;background:rgba(0,0,0,.5);z-index:9999;align-items:center;justify-content:center;">
          <div style="background:#fff;width:600px;max-width:90%;max-height:85vh;overflow-y:auto;padding:2em;position:relative;border-radius:4px;">
            <button id="jmt-req-close" style="position:absolute;top:.75em;right:.75em;background:none;border:none;font-size:1.5em;cursor:pointer;">&times;</button>
            <div id="jmt-req-body"></div>
          </div>
        </div>';

        echo '<script>
        jQuery(function($){
            var I18N = ' . wp_json_encode([
                'request'     => self::t( 'Aanvraag', 'Request' ),
                'name'        => self::t( 'Naam', 'Name' ),
                'email'       => self::t( 'E-mail', 'Email' ),
                'company'     => self::t( 'Bedrijf', 'Company' ),
                'event'       => self::t( 'Event', 'Event' ),
                'date'        => self::t( 'Datum', 'Date' ),
                'created'     => self::t( 'Aangemaakt', 'Created' ),
                'products'    => self::t( 'Producten', 'Products' ),
                'product'     => self::t( 'Product', 'Product' ),
                'qty'         => self::t( 'Aantal', 'Qty' ),
                'no_products' => self::t( 'Geen producten', 'No products' ),
            ]) . ';

            $(".jmt-view-req").on("click", function(){
                var r    = $(this).closest("tr").data("request");
                var cart = Array.isArray(r.cart) ? r.cart : [];
                var html = "<h2>" + I18N.request + " #" + r.id + "</h2>"
                         + "<p><strong>" + I18N.name    + ":</strong> "    + r.name               + "</p>"
                         + "<p><strong>" + I18N.email   + ":</strong> "    + r.email              + "</p>"
                         + "<p><strong>" + I18N.company + ":</strong> "    + (r.company    ||"-") + "</p>"
                         + "<p><strong>" + I18N.event   + ":</strong> "    + (r.event_name ||"-") + "</p>"
                         + "<p><strong>" + I18N.date    + ":</strong> "    + (r.event_date ||"-") + "</p>"
                         + "<p><strong>" + I18N.created + ":</strong> "    + r.created            + "</p>"
                         + "<h3>" + I18N.products + "</h3><table style=\'width:100%;border-collapse:collapse\'>"
                         + "<thead><tr><th style=\'text-align:left;padding:4px;border-bottom:1px solid #ccc\'>" + I18N.product + "</th>"
                         + "<th style=\'text-align:center;padding:4px;border-bottom:1px solid #ccc\'>" + I18N.qty + "</th></tr></thead><tbody>";
                if(cart.length){
                    cart.forEach(function(item){
                        html += "<tr><td style=\'padding:4px\'>" + item.title + "</td>"
                              + "<td style=\'padding:4px;text-align:center\'>" + item.qty + "</td></tr>";
                    });
                } else {
                    html += "<tr><td colspan=\'2\'>" + I18N.no_products + "</td></tr>";
                }
                html += "</tbody></table>";
                $("#jmt-req-body").html(html);
                $("#jmt-req-modal").css("display","flex");
            });
            $("#jmt-req-close, #jmt-req-modal").on("click", function(e){
                if(e.target === this) $("#jmt-req-modal").hide();
            });
        });
        </script>';

        echo '</div>';
    }

    // ── Settings page ─────────────────────────────────────────────────────────

    public static function page_settings() {
        echo '<div class="wrap"><h1>JMT Browser – ' . esc_html( self::t( 'Instellingen', 'Settings' ) ) . '</h1>';
        JMT_Settings::instance()->render_settings_page();
        echo '</div>';
    }
}
